export declare class Match {
    constructor(index: number, length: number, value: string, groups: any);
    index: number;
    length: number;
    value: string;
    private innerGroups;
    groups(key: string): {
        value: string;
        index: number;
        length: number;
        captures: string[];
    };
}
export declare class ConditionalMatch {
    constructor(match: Match, success: boolean);
    match: Match;
    success: boolean;
}
export declare class RegExpUtility {
    static getMatches(regex: RegExp, source: string): Match[];
    static getMatchEnd(regex: RegExp, source: string, trim: boolean): ConditionalMatch;
    static getMatchesSimple(regex: RegExp, source: string): Match[];
    static getSafeRegExp(source: string, flags?: string): RegExp;
    static getFirstMatchIndex(regex: RegExp, source: string): {
        matched: boolean;
        index: number;
        value: string;
    };
    static split(regex: RegExp, source: string): string[];
    static isMatch(regex: RegExp, source: string): boolean;
    private static matchGroup;
    private static matchPositiveLookbehind;
    private static matchNegativeLookbehind;
    private static sanitizeGroups;
    private static getNextRegex;
    private static getClosePos;
}
export declare class QueryProcessor {
    static readonly Expression: string;
    static readonly SpecialTokensRegex: RegExp;
    static preProcess(query: string, caseSensitive?: boolean, recode?: boolean): string;
    private static applyReverse;
    private static toLowerTermSensitive;
}
export declare class StringUtility {
    static isNullOrWhitespace(input: string): boolean;
    static isNullOrEmpty(input: string): boolean;
    static isWhitespace(input: string): boolean;
    static insertInto(input: string, value: string, index: number): string;
    static removeDiacriticsFromWordBoundaries(input: string): string;
    static removeDiacritics(c: string): string;
    private static readonly diacriticsRemovalMap;
}
